/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**
 * <p>jՓ擾NX</p>
 * iǉj<br>
 * nbs[}f[<br>
 * t̓AH̓̎擾<br>
 * j@ɂ鍑̏j̎擾
 * @author mind
 */
public class JapanHolidayUtility implements Serializable {

	private static final long serialVersionUID = -7341283435100183210L;

	private Calendar cal;
	private int yyyy;

	/**
	 * l̓ 12j
	 */
	private static final int SEIJIN_MONTH = 1;
	/**
	 * l̓ 12j
	 */	
	private static final int SEIJIN_DAY_OF_WEEK_IN_MONTH = 2;
	/**
	 * l̓
	 */	
	private static final String SEIJIN_NAME = "l̓";

	/**
	 * C̓ 73j
	 */
	private static final int UMI_MONTH = 7;
	/**
	 * C̓ 73j
	 */
	private static final int UMI_DAY_OF_WEEK_IN_MONTH = 3;
	/**
	 * C̓
	 */
	private static final String UMI_NAME = "C̓";

	/**
	 * hV̓ 93j
	 */
	private static final int KEIROU_MONTH = 9;
	/**
	 * hV̓ 93j
	 */
	private static final int KEIROU_DAY_OF_WEEK_IN_MONTH = 3;
	/**
	 * hV̓
	 */
	private static final String KEIROU_NAME = "hV̓";

	/**
	 * ̈̓ 102j
	 */
	private static final int TAIIKU_MONTH = 10;
	/**
	 * ̈̓ 102j
	 */
	private static final int TAIIKU_DAY_OF_WEEK_IN_MONTH = 2;
	/**
	 * ̈̓
	 */
	private static final String TAIIKU_NAME = "̈̓";


	/**
	 * t̓ 3dd
	 */
	private static final int SYUNBUN_MONTH = 3;
	/**
	 * t̓
	 */
	private static final String SYUNBUN_NAME = "t̓";

	/**
	 * H̓ 9dd
	 */
	private static final int SYUUBUN_MONTH = 9;
	/**
	 * H̓
	 */
	private static final String SYUUBUN_NAME = "H̓";


	/**
	 *  11
	 */
	private static final int GANJITSU_MONTH = 1;
	/**
	 *  11
	 */
	private static final int GANJITSU_DATE = 1;
	/**
	 * 
	 */
	private static final String GANJITSU_NAME = "";

	/**
	 * LO̓ 211
	 */
	private static final int KENKOKUKINEN_MONTH = 2;
	/**
	 * LO̓ 211
	 */
	private static final int KENKOKUKINEN_DATE = 11;
	/**
	 * LO̓
	 */
	private static final String KENKOKUKINEN_NAME = "LO̓";

	/**
	 * a̓ 429
	 */
	private static final int SYOUWA_MONTH = 4;
	/**
	 * a̓ 429
	 */
	private static final int SYOUWA_DATE = 29;
	/**
	 * a̓
	 */
	private static final String SYOUWA_NAME = "a̓";

	/**
	 * @LO 53
	 */
	private static final int KENPOUKINEN_MONTH = 5;
	/**
	 * @LO 53
	 */
	private static final int KENPOUKINEN_DATE = 3;
	/**
	 * @LO
	 */
	private static final String KENPOUKINEN_NAME = "@LO";

	/**
	 * ݂ǂ̓ 54
	 */
	private static final int MIDORI_MONTH = 5;
	/**
	 * ݂ǂ̓ 54
	 */
	private static final int MIDORI_DATE = 4;
	/**
	 * ݂ǂ̓
	 */
	private static final String MIDORI_NAME = "݂ǂ̓";

	/**
	 * ǂ̓ 55
	 */
	private static final int KODOMO_MONTH = 5;
	/**
	 * ǂ̓ 55
	 */
	private static final int KODOMO_DATE = 5;
	/**
	 * ǂ̓
	 */
	private static final String KODOMO_NAME = "ǂ̓";

	/**
	 * ̓ 113
	 */
	private static final int BUNKA_MONTH = 11;
	/**
	 * ̓ 113
	 */
	private static final int BUNKA_DATE = 3;
	/**
	 * ̓
	 */
	private static final String BUNKA_NAME = "̓";

	/**
	 * ΘJӂ̓ 1123
	 */
	private static final int KINROUKANSYA_MONTH = 11;
	/**
	 * ΘJӂ̓ 1123
	 */
	private static final int KINROUKANSYA_DATE = 23;
	/**
	 * ΘJӂ̓
	 */
	private static final String KINROUKANSYA_NAME = "ΘJӂ̓";

	/**
	 * Vca 1223
	 */
	private static final int TENNOUTANJOU_MONTH = 12;
	/**
	 * Vca 1223
	 */
	private static final int TENNOUTANJOU_DATE = 23;
	/**
	 * Vca
	 */
	private static final String TENNOUTANJOU_NAME = "Vca";

	/**
	 * ̋x
	 */
	private static final String KOKUMINNOKYUJITU_NAME = "̋x";


	/**
	 * jz
	 */
	private String[][] arySyuku = new String[15][2];

	/**
	 * j
	 */
	private String[] arySyukuName = {
			SEIJIN_NAME,
			UMI_NAME,
			KEIROU_NAME,
			TAIIKU_NAME,
			SYUNBUN_NAME,
			SYUUBUN_NAME,
			GANJITSU_NAME,
			KENKOKUKINEN_NAME,
			KENPOUKINEN_NAME,
			KODOMO_NAME,
			BUNKA_NAME,
			KINROUKANSYA_NAME,
			TENNOUTANJOU_NAME
	};

	private String[][] aryCombined;

	/**
	 * RXgN^
	 */
	public JapanHolidayUtility() {
		this.cal = Calendar.getInstance();
		this.yyyy = 0;
	}

	/**
	 * RXgN^
	 * @param year Ώ۔Nx
	 * <p>jՓz쐬</p>
	 */
	public JapanHolidayUtility(int year) {
		this.cal = Calendar.getInstance();
		this.yyyy = year;
		createHoliday();
	}

	/**
	 * RXgN^
	 * @param y N
	 * @param m 
	 * @param d 
	 */
	public JapanHolidayUtility(String y, String m, String d) {
		this.cal = Calendar.getInstance();
		cal.set(Integer.parseInt(y), Integer.parseInt(m) -1, Integer.parseInt(d));
	}

	/**
	 * RXgN^
	 * @param y N
	 * @param m 
	 */
	public JapanHolidayUtility(String y, String m) {
		this.cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, Integer.parseInt(y));
		cal.set(Calendar.YEAR,  Integer.parseInt(m) -1);
	}


	/**
	 * j擾\bh
	 * @return j
	 */
	public String retDayOfWeek() {
		int dw = cal.get(Calendar.DAY_OF_WEEK);
		List list = EnumYoubi.toArray();
		String youbi = (String)list.get(dw -1);
		return youbi;
	}

	/**
	 * wjۃ\bh
	 * @param youbi
	 * @return boolean
	 */
	public boolean isDayOfWeek(int youbi) {
		int dw = cal.get(Calendar.DAY_OF_WEEK);
		if (dw == youbi) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * wjԖڎ擾\bh
	 * @return int
	 */
	public int retDayOfWeekinMonth() {
		return cal.get(Calendar.DAY_OF_WEEK_IN_MONTH);
	}

	/**
	 * ő擾\bh
	 * @return int
	 */
	public int retMaximumDay() {
		return cal.getActualMaximum(Calendar.DAY_OF_MONTH);
	}

	/**
	 * J_[setter
	 * @param y N
	 * @param m 
	 */
	public void setYm(int y, int m) {
		cal.set(Calendar.YEAR, y);
		cal.set(Calendar.MONTH, m -1);
	}

	/**
	 * J_[setter
	 * @param y N
	 * @param m 
	 * @param d 
	 */
	public void setYmd(int y, int m, int d) {
		cal.set(y, m -1, d);
	}


	/**
	 * J_[clear
	 */
	public void calClear() {
		cal.clear();
	}

	/**
	 * <p>j擾\bh</p>
	 * wN獑̏j擾
	 */
	public void createHoliday() {
		// 1~12for܂킷
		for (int i = 1; i <= 12; i++) {
			// ̌̓擾
			setYm(yyyy, i);
			int days = retMaximumDay();
			// ł܂킷
			for (int j = 1; j <= days; j++) {
				// tZbg
				setYmd(yyyy, i, j);
				// ĵ݌
				if (isDayOfWeek(Calendar.MONDAY)) {
					// l̓
					if ((i == SEIJIN_MONTH) && (SEIJIN_DAY_OF_WEEK_IN_MONTH == retDayOfWeekinMonth())) {
						arySyuku[0][0] = convYMD(yyyy, i,j);
					}
					// C̓
					if ((i == UMI_MONTH) && (UMI_DAY_OF_WEEK_IN_MONTH == retDayOfWeekinMonth())) {
						arySyuku[1][0] = convYMD(yyyy, i, j);
					}
					// hV̓
					if ((i == KEIROU_MONTH) && (KEIROU_DAY_OF_WEEK_IN_MONTH == retDayOfWeekinMonth())) {
						arySyuku[2][0] = convYMD(yyyy, i,j);
					}
					// ̈̓
					if ((i == TAIIKU_MONTH) && (TAIIKU_DAY_OF_WEEK_IN_MONTH == retDayOfWeekinMonth())) {
						arySyuku[3][0] = convYMD(yyyy, i,j);
					}
					// t̓
					if ((i == SYUNBUN_MONTH)) {
						arySyuku[4][0] = getSyunbunDate(); 
					}
					// H̓
					if ((i == SYUUBUN_MONTH)) {
						arySyuku[5][0] = getSyuubunDate(); 
					}
				}
			}
		}
		// 
		arySyuku[6][0] = convYMD(yyyy, GANJITSU_MONTH, GANJITSU_DATE);
		// LO̓
		arySyuku[7][0] = convYMD(yyyy, KENKOKUKINEN_MONTH, KENKOKUKINEN_DATE);
		// @LO
		arySyuku[8][0] = convYMD(yyyy, KENPOUKINEN_MONTH, KENPOUKINEN_DATE);
		// ǂ̓
		arySyuku[9][0] = convYMD(yyyy, KODOMO_MONTH, KODOMO_DATE);
		// ̓
		arySyuku[10][0] = convYMD(yyyy, BUNKA_MONTH, BUNKA_DATE);
		// ΘJӂ̓
		arySyuku[11][0] = convYMD(yyyy, KINROUKANSYA_MONTH, KINROUKANSYA_DATE);
		// Vca
		arySyuku[12][0] = convYMD(yyyy, TENNOUTANJOU_MONTH, TENNOUTANJOU_DATE);
		// ݂ǂ̓2006N܂429Aa̓2007N瓱
		arySyuku[13][0] = convYMD(yyyy, SYOUWA_MONTH, SYOUWA_DATE);
		// ̋x2006N܂54A݂ǂ̓2007N瓱
		arySyuku[14][0] = convYMD(yyyy, MIDORI_MONTH, MIDORI_DATE);
		// 2007NȑO2007Nȍ~ŏjՓzύX
		for (int k = 0; k < arySyuku.length; k++) {
			if (k < arySyukuName.length) {
				arySyuku[k][1] = arySyukuName[k];
			} else if (k == arySyukuName.length) {
				// ݂ǂ̓
				if (yyyy <= 2006) {
					arySyuku[k][1] = MIDORI_NAME;
				} else {
					arySyuku[k][1] = SYOUWA_NAME;
				}
			} else if (k == arySyukuName.length + 1) {
				// ̋x
				if (yyyy <= 2006) {
					arySyuku[k][1] = KOKUMINNOKYUJITU_NAME;
				} else {
					arySyuku[k][1] = MIDORI_NAME;
				}
			}
		}
	}

	/**
	 * <p>Ro[g\bh</p>
	 * intœ͂ꂽyyyy,mm,ddString֕ϊ
	 * @param y N
	 * @param m 
	 * @param d 
	 * @return yyyymmdd
	 */
	public String convYMD(int y, int m, int d) {
		String syy = "";
		String smm = "";
		String sdd = "";
		String yyyymmdd = "";
		syy = Integer.toString(y);
		if (m < 10) {
			smm = "0" + m;
		} else {
			smm = Integer.toString(m);
		}
		if (d < 10) {
			sdd = "0" + d;
		} else {
			sdd = Integer.toString(d);
		}
		yyyymmdd = syy + "/" + smm + "/" + sdd;
		return yyyymmdd;
	}

	/**
	 * jz擾\bh
	 * @return arySyuku
	 */
	public String[][] getArySyuku() { return arySyuku.clone(); }

	/**
	 * jz擾\bh
	 * @return aryCombined
	 */
	public String[][] getAryCombinedHoliday() { return aryCombined.clone(); }

	/**
	 *  t̓̓t𓾂(1900`2099N܂)
	 *  @return yyyymmdd INt̓
	 */
	public String getSyunbunDate() {
		double date = 21.4471d + (0.242377d * (yyyy-1900)) - Math.floor((yyyy-1900) /4.0d);
		int dd = (int)Math.floor(date);
		return convYMD(yyyy, SYUNBUN_MONTH, dd);
	}

	/**
	 *  H̓̓t𓾂(1900`2099N܂)
	 *  @return yyyymmdd INH̓
	 */
	public String getSyuubunDate() {
		double date = 23.8896d + (0.242032d * (yyyy-1900)) - Math.floor((yyyy-1900) /4.0d);
		int dd = (int)Math.floor(date);
		return convYMD(yyyy, SYUUBUN_MONTH, dd);
	}

	private enum EnumYoubi {
		SUN(""), 
		MON(""), 
		TUE(""), 
		WED(""),
		THU(""),
		FRI(""),
		SAT("y");

		private String dw;

		private EnumYoubi(String youbi) {
			this.dw = youbi;
		}

		public String toString() {
			return (this.dw);
		}

		static List toArray() {

			ArrayList<String> array = new ArrayList<String>();
			array.add(EnumYoubi.SUN.toString());
			array.add(EnumYoubi.MON.toString());
			array.add(EnumYoubi.TUE.toString());
			array.add(EnumYoubi.WED.toString());
			array.add(EnumYoubi.THU.toString());
			array.add(EnumYoubi.FRI.toString());
			array.add(EnumYoubi.SAT.toString());
			return array; 
		}
	}

	public void setYyyy(int yyyy) { this.yyyy = yyyy; }

}
